$(function(){
  var collapsedGroups = [];

  //Helper function
  function templateWithGroup(group){
    var template = $('#group-template').html();
    template = $(template);
    var moduleTable = template.find('table');
    template.find('h2').text(group.name);

    template.find('h2').on('click', function(){
      moduleTable.toggle();
      $(this).toggleClass('collapsed');

      if($(this).hasClass('collapsed')){
        collapsedGroups.push(group.name);
      }
      else{
        let index = collapsedGroups.indexOf(group.name);
        if(index != -1){
          collapsedGroups.splice(index, 1);
        }
      }
    });

    let isCollpased = !group.isExpanded;
    if(collapsedGroups.indexOf(group.name) != -1){
      isCollpased = true;
    }

    if(isCollpased){
      template.find('h2').addClass('collapsed');
      moduleTable.hide();
    }

    group.modules.forEach(function(module){
      moduleTable.append(templateWithModule(module));
    });

    return template;
  }

  function templateWithModule(module){
    var template = $('#row-template').html();
    template = $(template);

    template.find('.module-name').text(module.name);

    var valueElem = template.find('.module-value');
    if(module.result){
      valueElem.text(module.result);

      if(module.options){
        var color = module.options.color;
        if(color){
          valueElem.css('color', color);
        }
      }

      if(module.onClick){
        valueElem.addClass('clickable');
        valueElem.on('click', function(){
          window.open(module.onClick);
        });
      }
    }
    else if(typeof(module.updating) !== 'undefined'){
      valueElem.html(' <i class="fas fa-circle-notch fa-spin"></i>');

    }
    else if(typeof(module.hasAllRequiredFields) !== 'undefined' && !module.hasAllRequiredFields){
      var caution = $('#caution-icon-template').html();
      caution = $(caution);
      valueElem.html(caution);
    }
    else if(!module.success){
      var caution = $('#caution-icon-template').html();
      caution = $(caution);
      valueElem.html(caution);
      valueElem.addClass('error');
    }

    return template;
  }

  function parseJSON(json){
    $('#groups').empty();
    json.forEach(function(group){
      $('#groups').append(templateWithGroup(group));
    });
  }

  function getModulesWithFilter(){
    $.get('./output.json', function(json){
      parseJSON(json);
    });

  }

  getModulesWithFilter();

  function listen(){
    $.get('/listen', function(json){
      listen();

      parseJSON(json);
    });
  }

  listen();
});